unit Unit1;

//     (  )
//       CopyRect
//  BrushCopy   TCanvas.     
//  BrushCopy    .

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    ScrollBox1: TScrollBox;
    Image1: TImage;
    StaticTextX: TStaticText;
    StaticTextY: TStaticText;
    Label1: TLabel;
    Label2: TLabel;
    ComboBoxOP: TComboBox;
    StaticTextExcColor: TStaticText;
    Panel1: TPanel;
    Image2: TImage;
    LabelTitle: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    procedure FormActivate(Sender: TObject);
    procedure Image1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Image1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Image1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

var StartFlag   : boolean;
    SelectFlag  : boolean;
    SelectRect  : TRect;
    ExcColor    : TColor;

//     Images  
//   .
procedure ImagesCopyBrush(FromImage, ToImage : TImage;
                          FromRect : TRect; ExclureColor : TColor);
var  ToRect : TRect;
begin
    //  Image 
    ToImage.Canvas.Brush.Style := bsSolid;
    ToImage.Canvas.Brush.Color := ToImage.Parent.Brush.Color;
    ToImage.Canvas.Rectangle(0,0,ToImage.Width,ToImage.Height);
    ToRect := Rect(1,1, 1 + FromRect.Right  - FromRect.Left,
                        1 + FromRect.Bottom - FromRect.Top);
    //     
    ToImage.Canvas.BrushCopy(ToRect,
                             FromImage.Picture.Bitmap,
                             FromRect, ExclureColor);
end;

//     Images
procedure ImagesCopyRect(FromImage, ToImage : TImage; FromRect : TRect);
var  ToRect : TRect;
begin
    //  Image 
    ToImage.Canvas.Brush.Style := bsSolid;
    ToImage.Canvas.Brush.Color := ToImage.Parent.Brush.Color;
    ToImage.Canvas.Rectangle(0,0,ToImage.Width,ToImage.Height);
    ToRect := Rect(1,1, 1 + FromRect.Right  - FromRect.Left,
                        1 + FromRect.Bottom - FromRect.Top);
    //  
    ToImage.Canvas.CopyRect(ToRect, FromImage.Canvas, FromRect);
end;

//   Images,  
//     Image - 
procedure TForm1.FormActivate(Sender: TObject);
begin
  SelectFlag  := False;
  Image1.AutoSize := False;
  Image1.Stretch := False;
  Image2.AutoSize := False;
  Image2.Stretch := False;
  ExcColor := StaticTextExcColor.Color;
  Image1.Picture.LoadFromFile('.\Image\TEST.BMP');
end;

//      Image - 
procedure TForm1.Image1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
   SelectFlag  := False;
   StartFlag   := False;
   if Button = mbLeft  // mbLeft, mbRight, mbMiddle
   then begin
     SelectFlag  := True;
     Image1.Canvas.Brush.Style := bsClear;
   end
   else begin
     ExcColor := Image1.Canvas.Pixels[X, Y];
     StaticTextExcColor.Color := ExcColor;
   end;
end;

//      Image - 
procedure TForm1.Image1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  //   
  StaticTextX.Caption := IntToStr(X);
  StaticTextY.Caption := IntToStr(Y);
  //      
  if SelectFlag
  then begin
     //    Canvas.Pen
     Image1.Canvas.Pen.Mode := pmNot;
     if StartFlag
     then begin
        //    
        Image1.Canvas.Rectangle(SelectRect);
        SelectRect := Rect(SelectRect.Left, SelectRect.Top, X, Y);
        //    
        Image1.Canvas.Rectangle(SelectRect);
     end
     else begin
        StartFlag := True;
        SelectRect := Rect(X,Y, X,Y);
        //    
        Image1.Canvas.Rectangle(SelectRect);
     end;
  end;
end;

//      Image - ,
//      
procedure TForm1.Image1MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  //  
  StartFlag   := False;
  SelectFlag  := False;
  if Button = mbLeft  // mbLeft, mbRight, mbMiddle
  then begin
    //      
    Image1.Canvas.Rectangle(SelectRect);
    Image1.Canvas.Pen.Mode := pmCopy;
    Image1.Canvas.Brush.Style := bsSolid;
    case ComboBoxOP.ItemIndex of
     0: ImagesCopyRect(Image1, Image2, SelectRect);
     1: ImagesCopyBrush (Image1, Image2, SelectRect, ExcColor);
    end;
  end;
end;

end.

